import split_images
from split_car_plate_number import split_car_plate_number   
from sklearn.neighbors import KNeighborsClassifier
import os
import numpy as np
from PIL import Image


# 将图像使用平均值法二值化后再转为一维数组
def get_one_line_img(img_path):
    '''
    第一节课的内容:
    https://xde-webclub.github.io/project/
    '''
    img_data = Image.open(img_path)
    img_data_L = img_data.convert('L')
    img_data_List = np.array(img_data_L)
    threshold = img_data_List.mean()
    '''
    火山下的文明:数组展平 .flatten()
    '''
    return (img_data_List > threshold ).astype(int).flatten()
# 读取训练数据
def get_np_array(train_path = 'archive') -> list:
    '''
    列表、循环的基础应用
    '''
    y_train = []
    X_train = []
    for file in os.listdir(train_path):
        tag = file.replace('class_','')
        file_path = os.path.join(train_path,file)
        for img in os.listdir(file_path):
            img_path = os.path.join(file_path,img)
            # 转成一维数组
            i01 = get_one_line_img(img_path)
            X_train.append(i01)
            y_train.append(tag)
    return np.array(X_train) , np.array(y_train)
# 训练模型
def sklearn_model(img_path:str) -> str:
    '''
    上个学期的内容：
    https://xde-webclub.github.io/docs/%E7%AC%AC3%E9%83%A8%E5%88%86%E4%BC%A0%E7%BB%9F%E7%AE%97%E6%B3%95%E5%85%A5%E9%97%A8/K-%E9%82%BB%E8%BF%91%E7%AE%97%E6%B3%95 
    '''
    X_train , y_train = get_np_array()
    knn = KNeighborsClassifier(n_neighbors=3)
    knn.fit(X_train, y_train)
    reslut = ''
    # 给定图片路径，按顺序返回切割后的子图片的一维数组。
    for i in split_car_plate_number(img_path):
        i = i.flatten().reshape(1,-1)
  
        reslut += knn.predict(i)[0]
    return reslut

def model(model_name:str,img_path:str) -> str:
    if model_name == 'model1':
        try:
            return sklearn_model(img_path)
        except:
            return '识别失败'
    elif model_name == 'model2':
       
        return '识别结果2'
    elif model_name == 'model3':
 
        return '识别结果3'
